library(semPlot)
library(lavaan)

#################################################
#  P 
hobbydata <- read.table("data/hobby.dat",sep=",",header=TRUE)

hobbydata                                 ;#\1.1
hist(hobbydata[,1],breaks=c((0:6)+0.5))
hist(hobbydata[,2],breaks=c((0:6)+0.5))
hist(hobbydata[,3],breaks=c((0:6)+0.5))
hist(hobbydata[,4],breaks=c((0:6)+0.5))
hist(hobbydata[,5],breaks=c((0:6)+0.5))
hist(hobbydata[,6],breaks=c((0:6)+0.5))   ;#}1.1

round(colMeans(hobbydata),3)              ;#\1.2

v<-numeric(6)
for (i in 1:6){
  v[i]<- mean((hobbydata[,i]-mean(hobbydata[,i]))^2)}  
  print(round(v,3))                       ;#W{U
round(diag(var(hobbydata)),3)             ;#sΕU
round(sqrt(v),3)                          ;#W{W΍
round(sapply(hobbydata, sd),3)            ;#sΕUɂW΍

#################################################
#  Q 
#xNg͍s̓ʂȏꍇƂČvZB
# %*% ͍s̊|Z̉ZqłB
# x1='self1', x2='self2', x3='other1', x4='other2', x5='meta1', x6='meta2

hobbydata <- read.table("data/hobby.dat",sep=",",header=TRUE)
colnames(hobbydata)<-paste("x",1:6,sep="")

(X <- t(hobbydata))                                  ;#(2. 2)
t(X)                                                 ;#(2. 3)
(Xa <- rbind(X,rep(1,6)))                            ;#(2. 5)
xb<-(1/30) * (X %*% matrix(rep(1,30),30,1))        
round(xb,3)                                          ;#(2.10)
V<- X-xb %*% matrix(rep(1,30),1,30) ;round(t(V),3)   ;#(2.15)
D <-diag(diag((1/30)*(V %*% t(V)))) ;round(D ,3)     ;#(2.19)
Du<-diag(diag((1/29)*(V %*% t(V)))) ;round(Du,3)     ;#(2.20)
D1_2 <- sqrt(D )                    ;round(D1_2, 3)  ;#(2.21)
Du1_2<- sqrt(Du)                    ;round(Du1_2,3)  ;#(2.22)
Dm1_2 <- diag(1/diag(D1_2))         ;round(Dm1_2,3)
Z <- Dm1_2 %*% V                    ;round(t(Z),3)   ;#(2.25)
M <-(1/30)*(X %*% t(X ))            ;round(M ,3)     ;#(2.36)
Ma<-(1/30)*(Xa%*% t(Xa))            ;round(Ma,3)     ;#(2.37)
S <-(1/30)*(V %*% t(V ))            ;round(S ,3)     ;#(2.43)
Su<-(1/29)*(V %*% t(V ))            ;round(Su,3)     ;#(2.44)
R <-(1/30)*(Z %*% t(Z ))            ;round(R ,3)     ;#(2.47)


#################################################
#  R PdAg ̈
#  ֍s񂩂́̕if[^Α17͂̕sj
#  L2P^ŌvZA(3.34)(3.35)Ɉv
#  V1='1',V2='1',V3='^1
lower    <- '
 1.00             
-0.08  1.00      
 0.03 -0.22 1.000
'
full <- getCov(lower, names=paste("V",1:3,sep="") )
model <- '
V2    ~ A2_1 * V1
V3    ~ A3_2 * V2+ A3_1 * V1
'
fit <- sem(model, sample.cov=full, sample.nobs=30)
summary(fit, standardized=T)

#################################################
#  R PdAg ̈
#  f[^̕
#  L̂߂ɁAǑvZƂ͈vȂǂA炪m

hobbydata <- read.table("data/hobby.dat",sep=",",header=TRUE)
X<-hobbydata[,c(1,3,5)]
colnames(X)<-paste("V",1:3,sep="")
round(cov(X),3)
round(cor(X),3)

fit <- sem(model, data=X)
summary(fit, standardized=T)

semPaths(fit, whatLabels  = "est", nDigits=3, curve=1.5, shapeMan="square", sizeMan =10, exoVar=F)
title(main="R PdAg ̈",sub="ramX^CEW", line=1.0, cex.main =2.0)

semPaths(fit, whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =10, style = "lisrel")
title(main="R PdAg ̈",sub="lisrelX^CEW", line=1.0, cex.main =2.0)


#################################################
#  S͒Pq̓fLeXg
# ۂߌ덷̂߂ɔW͍וňvĂȂ
X <- read.table("data/LeXg_raw.csv",sep=",",header=TRUE)
round(cov(X),2)     ;#p.54 
round(cor(X),3)     ;#p.54 

model <- '
F1 =~ V1 + V2 + V3
'
fit <- sem(model, data=X, std.lv=T, estimator="ML")
summary(fit, standardized=T)

semPaths(fit, whatLabels  = "stand", nDigits=3, curve=1.5, shapeMan="square", sizeMan =10, sizeLat =14, sizeLat2 =10)
title(main="S͒Pq̓fLeXg", line=0.5, cex.main = 1.5)

#}ɕ`
semPaths(fit, whatLabels  = "stand", nDigits=3, curve=1.5, shapeMan="square", sizeMan =10, sizeLat =14, sizeLat2 =10, rotation=2)
title(main="S͒Pq̓fLeXg", line=0.5, cex.main = 1.5)

#lisrelX^C
semPaths(fit, whatLabels  = "stand", nDigits=3, curve=1.5, shapeMan="square", sizeMan =10, sizeLat =14, sizeLat2 =10, style = "lisrel")
title(main="S͒Pq̓fLeXg", line=0.5, cex.main = 1.5)


#################################################
#  S T̊w̓eXgf
# V1='keisan'V2='kannji'V3='seibutu' V4='tiri'V5='kokugo
X <- read.table("data/T̊w_raw.csv",sep=",",header=TRUE)
round(cov(X),2)
round(cor(X),2)     ;#p.71 

model <- '
F1 =~ V1 + V3 + V4
F2 =~ V2 + V3 + V4 + V5
V1 ~~ V2
F1 ~~ F2
'
fit <- sem(model, data=X, std.lv=T, estimator="ML", likelihood="normal")
summary(fit, standardized=T)

semPaths(fit, layout = "tree2", whatLabels  = "stand", nDigits=3, curve=1.3, shapeMan="square", sizeMan =6, sizeLat =10, sizeLat2 =8, rotation=1)
title(main="S T̊w̓eXgf", line=0.5, cex.main = 2)

#lisrelX^C
semPaths(fit, layout = "tree3", whatLabels  = "stand", nDigits=3, curve=0.8, shapeMan="square", sizeMan =6, sizeLat =10, sizeLat2 =8, rotation=1, style = "lisrel", residScale=10)
title(main="S T̊w̓eXgf", line=0.5, cex.main = 1.5)


#################################################
#  S mFIq ̈
# V1='self1'V2='self2'V3='other1' V4='other2'V5='meta1'V6='meta2
hobbydata <- read.table("hobby.dat",sep=",",header=TRUE)
colnames(hobbydata)<-paste("V",1:6,sep="")

model <- '
F1 =~ A1_1 * V1 + A1_1 * V2
F2 =~ A3_2 * V3 + A3_2 * V4
F3 =~ A5_3 * V5 + A5_3 * V6
V1 ~~ se1 * V1
V2 ~~ se1 * V2
V3 ~~ se3 * V3
V4 ~~ se3 * V4
V5 ~~ se5 * V5
V6 ~~ se5 * V6
'
fit <- sem(model, data=hobbydata, std.lv=T, std.ov=F)
summary(fit, standardized=T)
semPaths(fit, layout = "circle2", whatLabels  = "stand", nDigits=3, curve=0.8, shapeMan="square", sizeMan =7, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12)
title(main="S mFIq ̈", line=0.5, cex.main = 1.5)

#springŕ`
semPaths(fit, layout = "spring", whatLabels  = "stand", nDigits=3, curve=0.8, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12)
title(main="S mFIq ̈", line=0.5, cex.main = 1.5)

#################################################
#  T͘AfϋqϓIn
# x1='', x2='EƓIn', x3='ϓIȎ',
# x4='ϓIȐEƓIn', x5='ϓIȎЉIn'

X <- read.table("data/Kluegel_raw.csv",sep=",",header=TRUE)
round(cor(X),3)     ;#p.86 i
V<-X[,c(1,3,5)]; colnames(V)<-paste("V",1:3,sep="")
round(cor(V),3) 

model <- '
V2~A2_1*V1
V3~A3_2*V2
'
fit <- sem(model, data=V)
summary(fit, standardized=T)

semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =10, style = "lisrel")
title(main="T͘AfϋqϓIn", line=1.0, cex.main =1.5)


#################################################
#  T͒fϋqϓIn
#  V1='income'V2='status' V3='subincome'V4='substatus
V<-X[,1:4]; colnames(V)<-paste("V",1:4,sep="")
round(cor(V),3) 

model <- '
V3 ~  A3_1*V1+A3_2*V2
V4 ~  A4_2*V2+A4_3*V3
V1 ~~ V2
'
fit <- sem(model, data=V)
summary(fit, standardized=T)

semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =10, style = "lisrel", rotation=2, residScale=15)
title(main="T͒fϋqϓIn", line=1.0, cex.main =1.5)


#################################################
#  T͊SϋqϓIn
#  V1='income'V2='status' V3='subincome'V4='substatus

model <- '
V2 ~ A2_1*V1
V3 ~ A3_1*V1+A3_2*V2
V4 ~ A4_1*V1+A4_2*V2+A4_3*V3
V1 ~~ 1.0*V1
'
fit <- sem(model, data=V)
summary(fit, standardized=T)

semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =8, style = "lisrel", rotation=2, residScale=15, layout = "spring")
title(main="T͊SϋqϓIn", line=1.0, cex.main =1.5)

#################################################
#  T͑ϗʉAϋqϓIn
#  V1='income'V2='status' V3='subincome'V4='substatus

model <- '
V3 ~  A3_1*V1+A3_2*V2
V4 ~  A4_1*V1+A4_2*V2
V1 ~~ V2
V3 ~~ V4
'
fit <- sem(model, data=V)
summary(fit, standardized=T)

semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =8, style="lisrel", residScale=15, layout = "tree", curve=2.5, curvePivot=T, rotation=2)
title(main="T͑ϗʉAϋqϓIn", line=1.0, cex.main =1.5)

#################################################
#  T͔񒀎fϋqϓIn
# V1='income'V2='status'V3='subincome' V4='substatus'V5='sub-so-status
V<-X[,1:5]; colnames(V)<-paste("V",1:5,sep="")
round(cor(V),3) 

model <- ' 
V3 ~  V1 + V4
V4 ~  V2 + V3
V5 ~  V3 + V4
V3 ~~ V4
V3 ~~ V5
V4 ~~ V5
'

fit <- sem(model, data=V)
summary(fit, standardized=T)
semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =8, style="lisrel", residScale=15, layout ="spring", curve=1.0)
title(main="T͔񒀎fϋqϓIn", line=1.0, cex.main =1.5)

#################################################
#T͊Oϑƌ덷ϐ̑

model <- '
V3 ~ V1
V4 ~ V2
V5 ~ V3 + V4
V1 ~~ V2
V1 ~~ V4
V2 ~~ V3
'
fit <- sem(model, data=V)
summary(fit, standardized=T)

#ramX^CspringȂ`
semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =8, style="raml", residScale=15, layout = "spring", curve=2.5, curvePivot=T, rotation=3)

#################################################
#T͊Kgʔ񒀎f

model <- '
V3 ~ V1
V4 ~ V2 + V3 + V5
V5 ~ V3 + V4
V1 ~~ V2
'
fit <- sem(model, data=V)
summary(fit, standardized=T)

semPaths(fit, whatLabels="stand", nDigits=3, shapeMan="square", sizeMan =8, style="raml", residScale=15, layout = "spring", curve=0.5, curvePivot=T, rotation=3)


#################################################
#  U ɑ΂-2-
# V1='self1'V2='self2'V3='other1' V4='other2'V5='meta1'V6='meta2
hobbydata <- read.table("hobby.dat",sep=",",header=TRUE)
colnames(hobbydata)<-paste("V",1:6,sep="")

model <- '
F1 =~ 1.00 * V1 + 1.00 * V2
F2 =~ 1.00 * V3 + 1.00 * V4
F3 =~ 1.00 * V5 + 1.00 * V6
F2 ~  B2_1*F1
F3 ~  B3_2*F2+B3_1*F1
V1 ~~ se1 * V1
V2 ~~ se1 * V2
V3 ~~ se3 * V3
V4 ~~ se3 * V4
V5 ~~ se5 * V5
V6 ~~ se5 * V6
'
fit <- sem(model, data=hobbydata)
summary(fit, standardized=T)
semPaths(fit, layout = "spring", whatLabels  = "stand", nDigits=3, curve=0.8, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12)
title(main="U ɑ΂-2-", line=0.5, cex.main = 1.5)

#treeŕ`
semPaths(fit, layout = "tree2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12)
title(main="U ɑ΂-2-", line=0.5, cex.main = 1.5)

#circleŕ`
semPaths(fit, layout = "circle2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12, optimizeLatRes=T,levels=c(1.5,2,2,2))
title(main="U ɑ΂-2-", line=0.5, cex.main = 1.5)


#################################################
#  U Qq
# V1='TEST1'V2='TEST2'V3='TEST3'V4='TEST4'V5='TEST5'V6='TEST6
V <- read.table("data/Qq_raw.csv",sep=",",header=TRUE)
round(cor(V),3) ;#p104

model <- '
F2 =~ V1 + V2
F3 =~ V3 + V4
F4 =~ V5 + V6
F1 =~ F2 + F3 + F4
'
fit <- sem(model, data=V)
summary(fit, standardized=T)

semPaths(fit, layout = "tree2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12)
title(main="U Qq", line=0.5, cex.main = 1.5)


#################################################
#  U lhlhbf
# V1='syunyu'V2='gakureki'V3='isindo'V4='jinmya'V5='timeido'V6='sanka
V <- read.table("data/MIMIC_raw.csv",sep=",",header=TRUE)
round(cor(V),3) ;#p104

model <- '
F1 ~  V1 + V2 + V3
F1 =~ V4 + V5 + V6
'

fit <- sem(model, data=V, fixed.x=T)
summary(fit, standardized=T)

semPaths(fit, layout = "tree2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12, curve=0.7, optimizeLatRes=T)
title(main="U lhlhbf", line=0.5, cex.main = 1.5)

#################################################
#  U cfIfP
#  V1='ken1'V2='men1'V3='ken2'V4='men2' V5='ken3'V6='men3
V <- read.table("data/cf_raw.csv",sep=",",header=TRUE)
round(cor(V),3) ;#p106

model <- '
F1 =~ V1 + V2
F2 =~ V3 + V4
F3 =~ V5 + V6
F3 ~  F2
F2 ~  F1
'

fit <- sem(model, data=V)
summary(fit, standardized=T)

semPaths(fit, layout = "tree", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =8, sizeLat =8, sizeLat2 =8, style = "lisrel", residScale=12, curve=0.7, optimizeLatRes=T)
title(main="U cfIfP", line=0.5, cex.main = 1.5)

#################################################
#  U cfIfQ
# V1='ken1'V2='men1'V3='ken2'V4='men2' V5='ken3'V6='men3

model <- '
F1 =~ V1 + V3 + V5
F2 =~ V2 + V4 + V6
F3 =~ a*V1 + a*V2
F4 =~ b*V3 + b*V4
F5 =~ c*V5 + c*V6
F5 ~  F4
F4 ~  F3
F1 ~~ 0*F2 + 0*F3
F2 ~~ 0*F3
'

fit <- sem(model, data=V, std.lv=T)
summary(fit, standardized=T)
semPaths(fit, layout = "spring", whatLabels  = "stand", nDigits=2, shapeMan="square", sizeMan =4, sizeLat =4, sizeLat2 =4,edge.label.cex=0.8, exoCov=F, style = "lisrel", residScale=6, curve=1.2, optimizeLatRes=T)
title(main="U cfIfQ", line=0.5, cex.main = 1.5)


#################################################
#  U VvbNX\
# V1='P', V2='@', V3=' ǉ', V4='', V5='O'
V <- read.table("data/VvbNX_raw.csv",sep=",",header=TRUE)
round(cor(V),3) ;#p108

model <- '
F1 =~ V1
F2 =~ V2
F3 =~ V3
F4 =~ V4
F5 =~ V5
F2 ~   F1
F3 ~   F2
F4 ~   F3
F5 ~   F4
V1 ~~ a*V1
V2 ~~ a*V2
V3 ~~ a*V3
V4 ~~ a*V4
V5 ~~ a*V5
'

fit <- sem(model, data=V, std.lv=T)
summary(fit, standardized=T)

semPaths(fit, layout = "circle2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =5, sizeLat2 =5, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1, levels=c(4.5,5,6.5,5.5))
title(main="U VvbNX\", line=0.5, cex.main = 1.5)

#tee2ŕ`
semPaths(fit, layout = "tree2", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =5, sizeLat2 =5, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1)
title(main="U VvbNX\", line=0.5, cex.main = 1.5)


#################################################
#  U }UDPQ Q
V <- read.table("data/}6_12_raw.csv",sep=",",header=TRUE)
round(cor(V),3) ;#p108

model <- '
F1 =~ V1 + start(-.8)*V2
F2 =~ V3 + start(-.8)*V4
F3 =~ V6 + start(-.8)*V5
F3 ~  F1 + F2
F1 ~~ F2
'

fit <- sem(model, data=V, std.lv=T)
summary(fit, standardized=T)

semPaths(fit, layout = "spring", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =5, sizeLat2 =5, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1)
title(main="U }UDPQ Q", line=0.5, cex.main = 1.5)


#################################################
#  V 


#################################################
#  W Harman H. H.,̕sK
V <- read.table("data/Harman_raw.csv",sep=",",header=TRUE)
round(cor(V),3) ;#p141

model <- '
F1 =~ V1 + V2 + V3 + V4 + V5
'

fit <- sem(model, data=V, std.lv=T)
summary(fit, standardized=T)

semPaths(fit, layout = "tree", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =12, sizeLat2 =10, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1)
title(main="W Harman H. H.,̕sK", line=0.5, cex.main = 1.5)

#p^ƌ덷UŒ
model <- '
F1 =~ 1.0*V1 + V2 + V3 + V4 + V5
V1 ~~ 0.0*V1
'
fit <- sem(model, data=V, std.lv=T)
summary(fit, standardized=T)

semPaths(fit, layout = "tree", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =12, sizeLat2 =10, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1)
title(main="W Harman H. H.,̕sK \n p^ƌ덷UŒ", line=0.5, cex.main = 1.5)


#################################################
#  W  ֐semω
V <- read.table("data/8͖_raw.csv",sep=",",header=TRUE)
round(cor(V),3) ;#p141

model <- '
F1 =~ 1.0*V1 + V2 + V3 + V4
'
fit <- sem(model, data=V, std.lv=T)
summary(fit, standardized=T)
semPaths(fit, layout = "tree", whatLabels  = "stand", nDigits=3, shapeMan="square", sizeMan =5, sizeLat =12, sizeLat2 =10, style = "lisrel", residScale=11, optimizeLatRes=T, reorder=T, rotation=1)
title(main="W ", line=0.5, cex.main = 1.5)

#################################################
#  X 


#################################################
#  10 


#################################################
#  11 


#################################################
library(polycor)

#12 JeSJq
#estimator="WLS"̂قKlȏ̒lɋ߂

catego <- read.csv("data/I.csv",header=TRUE)
round(cor(catego[,1:5]),2)            #\12.2
round(cor(catego[,c(1:2,6:8)]),2)     #\12.2
catego[,6]<-as.factor(catego[,6])
catego[,7]<-as.factor(catego[,7])
catego[,8]<-as.factor(catego[,8])
discor<-hetcor(data=catego[,c(1:2,6:8)],ML=T,use="complete.obs")
round(discor$correlations,2)          #\12.3

model <- '
F1 =~ z1 + z2 + u3 + u4 + u5
'
#estimator="WLS"
fit <- cfa(model, data=catego, std.lv=T, ordered=c("u3","u4","u5"), estimator="WLS")
summary(fit, standardized=T)
#Klestimator="DWLS"
fit <- cfa(model, data=catego, std.lv=T, ordered=c("u3","u4","u5"))
summary(fit, standardized=T)

semPaths(fit, whatLabels  = "stand", nDigits=2, curve=1.5, shapeMan="square", sizeMan =5, sizeLat=5, exoVar=T, intercepts = T, layout ="tree",edge.label.cex=0.5,thresholds = T, ThreshAtSide=F, thresholdSize=1.0, intAtSide=T, sizeInt =2, sizeInt2 =3)
title(main="12 JeSJq", line=1.0, cex.main =2.0)

#################################################
#12 ڔ_2ꐔKݐσf

irt <- read.csv("data/irt.csv",header=TRUE)
model <- '
F1 =~ g1*u1 + g2*u2 + g3*u3 + g4*u4 + g5*u5 + g6*u6 + g7*u7 + g8*u8 + g9*u9
u1 | c1*t1
u2 | c2*t1
u3 | c3*t1
u4 | c4*t1
u5 | c5*t1
u6 | c6*t1
u7 | c7*t1
u8 | c8*t1
u9 | c9*t1
#irt̎ʗ͂ƍxɕϊ
a1 := g1/(1.0-(g1^2))^0.5;  b1 := c1/g1
a2 := g2/(1.0-(g2^2))^0.5;  b2 := c2/g2
a3 := g3/(1.0-(g3^2))^0.5;  b3 := c3/g3
a4 := g4/(1.0-(g4^2))^0.5;  b4 := c4/g4
a5 := g5/(1.0-(g5^2))^0.5;  b5 := c5/g5
a6 := g6/(1.0-(g6^2))^0.5;  b6 := c6/g6
a7 := g7/(1.0-(g7^2))^0.5;  b7 := c7/g7
a8 := g8/(1.0-(g8^2))^0.5;  b8 := c8/g8
a9 := g9/(1.0-(g9^2))^0.5;  b9 := c9/g9
'
fit <- cfa(model, data=irt, std.lv=T, ordered=c("u1","u2","u3","u4","u5","u6","u7","u8","u9"))
summary(fit, standardized=T)

#################################################
#12́@vrbgA
#o͂"Std.all"̕EāA(12.59)-(12.63)vZΈv
#ǂȂ̂ŎpIłȂA͗_IȊ֌Wĉ

catego <- read.csv("data/I.csv",header=TRUE)
catego[,1:2]<-scale(catego[,1:2])

model <- '
f  ~  g1*z1 + g2*z2
f  =~ g3*u3
f  ~~ 0.0*f
u3 |  c3*t1
'
fit <- lavaan(model, data=catego, fixed.x=T, ordered=c("u3"), meanstructure=F)
parameterEstimates(fit,standardized=T)
st<-parameterEstimates(fit,standardized=T)$std.all
round(a <- st[3]/(1.0-(st[3]^2))^0.5   ,4)   #(12.59)
round(b <- st[5]/st[3]                 ,4)   #(12.60)
round(a1<- a*st[1]                     ,4)   #(12.61)
round(a2<- a*st[2]                     ,4)   #(12.62)
round(a3<- (-1.0)*a*b                  ,4)   #(12.63)

#################################################
#  13͎̈ۂ̈q̕
#  V1='self1'V2='self2'V3='other1' V4='other2'V5='meta1'V6='meta2

hobbydata <- read.table("data/hobby.dat",sep=",",header=TRUE)
colnames(hobbydata)<-paste("V",1:6,sep="")

model <- '
F1 =~ a1 * V1 + a2 * V2
F2 =~ a1 * V3 + a2 * V4
F3 =~ a1 * V5 + a2 * V6
V1 ~~V1; V2~~V2; V3~~V3; V4~~V4; V5~~V5; V6~~V6
F1 ~~  1 * F1 + F2 +F3
F2 ~~  bb2* F2 + F3 
F3 ~~  bb3* F3 
V1 ~  c1 * 1 
V2 ~  c2 * 1 
V3 ~  c1 * 1 
V4 ~  c2 * 1 
V5 ~  c1 * 1 
V6 ~  c2 * 1 
F1 ~  0  * 1 
F2 ~       1 
F3 ~       1 
b2:=bb2^0.5
b3:=bb3^0.5
'
fit <- lavaan(model, data=hobbydata,likelihood="wishart", meanstructure=T)
summary(fit, standardized=T)

semPaths(fit, whatLabels  = "est", nDigits=2, curve=1.5, shapeMan="square", sizeMan =5, sizeLat=5, exoVar=T, intercepts = T, layout ="spring",edge.label.cex=0.5)
title(main="13͎̈ۂ̈q̕", line=1.0, cex.main =2.0)


#################################################
#  13͒m\̏cff[^
V <- read.table("data/m\cf_raw.csv",sep=",",header=TRUE)
round(cor(V),3); round(colMeans(V),3); round(sqrt(diag(cov(V))),3) ;#p235

model <- '
F1 =~ a1 * V1 + a2 * V2 + a3 * V3 + a4 * V4
F2 =~ a1 * V5 + a2 * V6 + a3 * V7 + a4 * V8
F1 ~~  1 * F1
F2 ~~      F2
V1 ~~ b1 * V1 + V5
V2 ~~ b2 * V2 + V6
V3 ~~ b3 * V3 + V7
V4 ~~ b4 * V4 + V8
V5 ~~ b1 * V5 
V6 ~~ b2 * V6 
V7 ~~ b3 * V7 
V8 ~~ b4 * V8 
V1 + V5 ~  c1 * 1 
V2 + V6 ~  c2 * 1 
V3 + V7 ~  c3 * 1 
V4 + V8 ~  c4 * 1 
F1 ~  0  * 1 
F2 ~  F1 + 1 
'
fit <- lavaan(model, data=V,likelihood="wishart", meanstructure=T)
summary(fit, standardized=T)

semPaths(fit, whatLabels  = "est", nDigits=2, curve=1.5, shapeMan="square", sizeMan =5, sizeLat=5, exoVar=T, intercepts = T, layout ="tree",edge.label.cex=0.5)
title(main="13͒m\̏cff[^", line=1.0, cex.main =2.0)


#################################################
#14͕΍l͎

#iw6080
V1 <- read.table("data/iw60_80_raw.csv",sep=",",header=TRUE)
round(cor(V1),3);  round(colMeans(V1),3); round(sqrt(diag(cov(V1))),3) ;#p249

#iw80100
V2 <- read.table("data/iw80_100_raw.csv",sep=",",header=TRUE)
round(cor(V2),3);  round(colMeans(V2),3); round(sqrt(diag(cov(V2))),3) ;#p249

#f[^̌
V1 <- transform(V1, group=1)
V2 <- transform(V2, group=2)
V  <- rbind(V1,V2)

model <- '
F1  =~  V1  +  V2  +  V3
F2  =~  V4  +  V5  +  V6
V1 ~~V1; V2~~V2; V3~~V3; V4~~V4; V5~~V5; V6~~V6
F1 ~~ c(g1,g2)*F1 + F2
F2 ~~ c(g1,g3)*F2
V1 +  V2  +  V3  +  V4  +  V5  +  V6 ~ 1
F1 ~ c(h7,h8)*1
F2 ~ c(h7,h9)*1
g1 == 1.0
h7 == 0.0
'

fit <- lavaan(model, data=V, group="group", likelihood="wishart", meanstructure=T,group.equal= c('intercepts','loadings'))
summary(fit, standardized=T)

semPaths(fit, whatLabels  = "est", nDigits=2, curve=1.5, shapeMan="square", sizeMan =5, sizeLat=5, exoVar=T, intercepts = T, layout ="tree",edge.label.cex=0.5)
title(main="14͕΍l͎", line=1.0, cex.main =2.0)



#################################################
#14͕sSf[^̕
#likelihood="wishart"ŋȏƈvB"normal"Ƃ

V1 <- read.table("data/sS1_raw.csv",sep=",",header=TRUE)
round(cor(V1),3);  round(colMeans(V1),3); round(sqrt(diag(cov(V1))),3) ;#p255

V2 <- read.table("data/sS2_raw.csv",sep=",",header=TRUE)
round(cor(V2),3);  round(colMeans(V2),3); round(sqrt(diag(cov(V2))),3) ;#p255

V3 <- read.table("data/sS3_raw.csv",sep=",",header=TRUE)
round(cor(V3),3);  round(colMeans(V3),3); round(sqrt(diag(cov(V3))),3) ;#p256

V4 <- read.table("data/sS4_raw.csv",sep=",",header=TRUE)
round(cor(V4),3);  round(colMeans(V4),3); round(sqrt(diag(cov(V4))),3) ;#p256

#f[^̌
V1 <- transform(V1, group=1)
V2 <- transform(V2, group=2)
V3 <- transform(V3, group=3)
V4 <- transform(V4, group=4)
V  <- rbind(V1,V2,V3,V4)

model <- '
F1 =~  c(a1,d1,g1,a1)*V1  +  c(b1,e1,h1,b1)*V2  +  c(c1,f1,i1,c1)*V3
F2 =~  c(d1,g1,j1,j1)*V4  +  c(e1,h1,k1,k1)*V5  +  c(f1,i1,l1,l1)*V6
F1 ~~  c(1,1,1,1)*F1 + F2
F2 ~~  c(1,1,1,1)*F2
V1 ~~  c(a2,d2,g2,a2)*V1
V2 ~~  c(b2,e2,h2,b2)*V2
V3 ~~  c(c2,f2,i2,c2)*V3
V4 ~~  c(d2,g2,j2,j2)*V4
V5 ~~  c(e2,h2,k2,k2)*V5
V6 ~~  c(f2,i2,l2,l2)*V6
V1 ~   c(a3,d3,g3,a3)*1
V2 ~   c(b3,e3,h3,b3)*1
V3 ~   c(c3,f3,i3,c3)*1
V4 ~   c(d3,g3,j3,j3)*1
V5 ~   c(e3,h3,k3,k3)*1
V6 ~   c(f3,i3,l3,l3)*1
F1 ~   c(0,0,0,0)*1
F2 ~   c(0,0,0,0)*1
'
fit <- lavaan(model, data=V, group="group", likelihood="wishart", group.equal=c('lv.covariances'), std.lv=T)
summary(fit, standardized=T)

semPaths(fit, whatLabels  = "est", nDigits=2, curve=1.5, shapeMan="square", sizeMan =5, sizeLat=5, exoVar=T, intercepts = T, layout ="tree",edge.label.cex=0.5)
title(main="14͕sSf[^̕", line=1.0, cex.main =2.0)


#################################################
#PŚ@s`w`bdf 
#likelihood="wishart"ŋȏƈvB"normal"Ƃ

#MZO[v
V1 <- read.table("data/s`MZ_raw.csv",sep=",",header=TRUE)
round(cov(V1),3) ;#p263

#DZO[v
V2 <- read.table("data/s`DZ_raw.csv",sep=",",header=TRUE)
round(cov(V2),3) ;#p263

#f[^̌
V1 <- transform(V1, group='MZ')
V2 <- transform(V2, group='DZ')
V  <- rbind(V1,V2)

model <- '
F1 =~ c(a,a)*V1
F2 =~ c(a,a)*V2
F3 =~ c(c,c)*V1 + c(c,c)*V2
F1 ~~ c(1.0, 1.0)*F1 + c(1.0, 0.5)*F2 + c(0.0, 0.0)*F3
F2 ~~ c(1.0, 1.0)*F2 + c(0.0, 0.0)*F3
F3 ~~ c(1.0, 1.0)*F3
V1 ~~ c(ee,ee)*V1
V2 ~~ c(ee,ee)*V2
e :=  ee^0.5
aa:=  a^2
cc:=  c^2
'
fit <- lavaan(model, data=V, group="group", likelihood="wishart", std.lv=T)
summary(fit, standardized=T)



